/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class GobberEntity
extends GoblinEntity
implements CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> HAS_CROSSBOW = SynchedEntityData.m_135353_(GobberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(GobberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.m_135353_(GobberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public GobberEntity(EntityType<? extends GobberEntity> type, Level worldIn) {
        super(type, worldIn);
        this.reassessWeaponGoal();
    }

    @Override
    public MobType getCreatureAttribute() {
        return CreatureAttributeInit.GOBLIN;
    }

    @Override
    public boolean m_6785_(double p_27492_) {
        return false;
    }

    public boolean hasCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(HAS_CROSSBOW);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isCharging()) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE;
        }
        if (this.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_HOLD;
        }
        return this.m_5912_() ? AbstractIllager.IllagerArmPose.ATTACKING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    private void setHasCrossbow(boolean hasCrossbow) {
        this.f_19804_.m_135381_(HAS_CROSSBOW, (Object)hasCrossbow);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    private void setSleeping(boolean isSleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)isSleeping);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new SleepGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CHARGING_STATE, (Object)false);
        this.f_19804_.m_135372_(HAS_CROSSBOW, (Object)false);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22278_, 7.5).m_22268_(Attributes.f_22277_, 25.0);
    }

    public boolean canDespawn(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_8023_() {
        return super.m_8023_();
    }

    protected void updateAITasks() {
        if (this.m_5803_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.15f);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_6851_(difficultyIn);
        this.reassessWeaponGoal();
        return spawnDataIn;
    }

    protected void m_6851_(DifficultyInstance difficulty) {
        super.m_6851_(difficulty);
        int i = this.f_19796_.nextInt(3);
        if (i == 0) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
            this.setHasCrossbow(true);
        } else {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        }
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            float f = this.f_19853_.m_6436_(this.m_142538_()).m_19056_();
            if (this.m_21205_().m_41619_() && this.m_6060_() && this.f_19796_.nextFloat() < f * 0.3f) {
                entityIn.m_20254_(2 * (int)f);
            }
        }
        return flag;
    }

    public void reassessWeaponGoal() {
        if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41720_() == Items.f_42717_) {
                this.f_21345_.m_25352_(0, (Goal)new RangedCrossbowAttackGoal((Monster)this, 1.0, 8.0f));
            }
            if (itemstack.m_41720_() != Items.f_42717_) {
                this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
            }
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }

    protected AbstractArrow getArrow(ItemStack arrowStack, float distanceFactor) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
    }

    public boolean m_5886_(ProjectileWeaponItem p_230280_1_) {
        return p_230280_1_ == Items.f_42717_;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ItemInit.GOBBER_SPAWN_EGG.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGING_STATE);
    }

    public void m_6136_(boolean isCharging) {
        this.f_19804_.m_135381_(DATA_CHARGING_STATE, (Object)isCharging);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    protected SoundEvent m_7515_() {
        if (this.m_5803_()) {
            return SoundInit.GOBBER_SNORING;
        }
        return SoundInit.GOBBER_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundInit.GOBBER_HURT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.GOBBER_DEATH;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsSleeping", this.m_5803_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.reassessWeaponGoal();
        this.setSleeping(compound.m_128471_("IsSleeping"));
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        super.m_8061_(slotIn, stack);
        if (!this.f_19853_.f_46443_) {
            this.reassessWeaponGoal();
        }
    }

    public void m_5811_(LivingEntity p_230284_1_, ItemStack p_230284_2_, Projectile p_230284_3_, float p_230284_4_) {
        this.m_32322_((LivingEntity)this, p_230284_1_, p_230284_3_, p_230284_4_, 1.6f);
    }

    public boolean m_7307_(Entity p_33314_) {
        if (super.m_7307_(p_33314_)) {
            return true;
        }
        if (p_33314_ instanceof LivingEntity && ((LivingEntity)p_33314_).m_6336_() == CreatureAttributeInit.GOBLIN) {
            return this.m_5647_() == null && p_33314_.m_5647_() == null;
        }
        return false;
    }

    class SleepGoal
    extends Goal {
        GobberEntity gobber;

        public SleepGoal(GobberEntity gobber) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.gobber = gobber;
        }

        public boolean m_8036_() {
            List players = GobberEntity.this.f_19853_.m_45976_(Player.class, GobberEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0));
            List illagers = GobberEntity.this.f_19853_.m_45976_(AbstractIllager.class, GobberEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0));
            List villagers = GobberEntity.this.f_19853_.m_45976_(AbstractVillager.class, GobberEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0));
            List golems = GobberEntity.this.f_19853_.m_45976_(AbstractGolem.class, GobberEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0));
            return players.isEmpty() && illagers.isEmpty() && villagers.isEmpty() && golems.isEmpty();
        }

        public boolean m_8045_() {
            List players = GobberEntity.this.f_19853_.m_45976_(Player.class, GobberEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0));
            List illagers = GobberEntity.this.f_19853_.m_45976_(AbstractIllager.class, GobberEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0));
            List villagers = GobberEntity.this.f_19853_.m_45976_(AbstractVillager.class, GobberEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0));
            List golems = GobberEntity.this.f_19853_.m_45976_(AbstractGolem.class, GobberEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0));
            return players.isEmpty() && illagers.isEmpty() && villagers.isEmpty() && golems.isEmpty();
        }

        public void m_8056_() {
            this.gobber.m_6710_(null);
            this.gobber.setSleeping(true);
            this.gobber.m_21573_().m_26573_();
            this.gobber.m_20334_(0.0, 0.0, 0.0);
            this.gobber.m_21051_(Attributes.f_22279_).m_22100_(0.0);
        }

        public void m_8041_() {
            super.m_8041_();
            this.gobber.setSleeping(false);
            this.gobber.m_21051_(Attributes.f_22279_).m_22100_((double)0.2f);
        }
    }
}

